/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.INonGridRow;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.MultiComponent;
import net.java.dev.designgridlayout.NonGridRowItem;
import net.java.dev.designgridlayout.PrefWidthExtractor;

abstract class AbstractNonGridRow
extends AbstractRow
implements INonGridRow {
    private final List<NonGridRowItem> _items = new ArrayList<NonGridRowItem>();
    private boolean _fill = false;
    private boolean _ownRowWidth = false;
    private int _compWidth = 0;
    private int _indent = 0;

    AbstractNonGridRow() {
    }

    @Override
    public INonGridRow add(JComponent ... children2) {
        for (JComponent component : children2) {
            this._items.add(new NonGridRowItem(component));
            this.parent().add(component);
        }
        return this;
    }

    @Override
    public INonGridRow addMulti(JComponent ... children2) {
        return this.add(new MultiComponent(this.growPolicy(), this.orientation(), children2));
    }

    @Override
    public INonGridRow indent() {
        return this.indent(1);
    }

    @Override
    public INonGridRow indent(int n) {
        if (n >= 0) {
            this._indent = ComponentGapsHelper.instance().getHorizontalIndent() * n;
        }
        return this;
    }

    @Override
    public INonGridRow fill() {
        this._fill = true;
        return this;
    }

    @Override
    public INonGridRow withOwnRowWidth() {
        this._ownRowWidth = true;
        return this;
    }

    List<NonGridRowItem> items() {
        return this._items;
    }

    @Override
    int totalNonGridWidth(int hgap, int unrelhgap) {
        int count2 = this._items.size();
        int totalWidth = this._compWidth * count2 + hgap * (count2 - 1) + this._indent;
        return totalWidth;
    }

    @Override
    int componentNonGridWidth() {
        return this._ownRowWidth ? 0 : this.actualComponentNonGridWidth();
    }

    private int actualComponentNonGridWidth() {
        return ComponentHelper.maxValues(this._items, PrefWidthExtractor.INSTANCE);
    }

    @Override
    void forceComponentNonGridWidth(int width) {
        this._compWidth = width > 0 && !this._ownRowWidth ? width : this.actualComponentNonGridWidth();
    }

    @Override
    int layoutRow(LayoutHelper helper, int left, int hgap, int gridgap, int unrelhgap, int rowWidth, int gridsWidth, List<Integer> labelsWidth) {
        int width;
        int x = left + this._indent;
        int count2 = this._items.size();
        int leftFiller = width = this._compWidth;
        int rightFiller = width;
        if (!this._fill) {
            int usedWidth = width * count2 + (count2 - 1) * hgap + this._indent;
            x += this.xOffset(rowWidth, usedWidth);
        } else {
            int availableWidth = rowWidth - this._indent - (count2 - 1) * hgap;
            leftFiller = this.leftFiller(count2, width, availableWidth);
            rightFiller = this.rightFiller(count2, width, availableWidth);
        }
        return this.layoutRow(helper, x, hgap, width, leftFiller, rightFiller);
    }

    protected int layoutRow(LayoutHelper helper, int left, int hgap, int width, int leftFiller, int rightFiller) {
        int x = left;
        int count2 = this._items.size();
        int i = 0;
        int actualHeight = 0;
        for (NonGridRowItem item : this._items) {
            int compWidth = i == 0 ? leftFiller : (i == count2 - 1 ? rightFiller : width);
            actualHeight = Math.max(actualHeight, helper.setSizeLocation(item.component(), x, compWidth, this.height(), this.baseline()));
            x += compWidth + hgap;
            ++i;
        }
        return actualHeight;
    }

    protected abstract int xOffset(int var1, int var2);

    protected abstract int leftFiller(int var1, int var2, int var3);

    protected abstract int rightFiller(int var1, int var2, int var3);
}

